function checkLongParagraphs() {
  const threshold = 400;
  const blocks = document.querySelectorAll(".module.source-text, .module.commentary");

  blocks.forEach((block) => {
    const height = block.scrollHeight;
    if (height > threshold) {
      block.classList.add("long-paragraph");
    } else {
      block.classList.remove("long-paragraph");
    }
  });
}

// Run once after initial DOM load
document.addEventListener("DOMContentLoaded", () => {
  setTimeout(checkLongParagraphs, 300); // Give Helix + modules time to layout tab1

  // Bind to tab link clicks
  const tabLinks = document.querySelectorAll(".tabs-style1 a");

  tabLinks.forEach((link) => {
    link.addEventListener("click", () => {
      // Wait ~300ms to let the DOM update the visible tab
      setTimeout(checkLongParagraphs, 300);
    });
  });
});