console.log("📘 glossary.js loaded");

const glossary = {
  Assooparatsata: "A made-up compound term from Beelzebub's Tales, often signifying an esoteric or technical process.",
  Hivintzes: "Modern people, often implying superficiality or lack of true understanding.",
  Karapet: "A character from Tiflis known for his humorous curses before blowing the station whistle.",
  // Add more entries here as needed
};

function wrapGlossaryTerms(container = document.body) {
  const textNodes = [];

  function getTextNodes(node) {
    if (node.nodeType === Node.TEXT_NODE && node.nodeValue.trim()) {
      textNodes.push(node);
    } else if (node.nodeType === Node.ELEMENT_NODE && !['SCRIPT', 'STYLE', 'TEXTAREA'].includes(node.tagName)) {
      for (const child of node.childNodes) getTextNodes(child);
    }
  }

  getTextNodes(container);

  textNodes.forEach(node => {
    let replaced = node.nodeValue;
    Object.keys(glossary).forEach(term => {
      const re = new RegExp(`\\b(${term})\\b`, 'g');
      replaced = replaced.replace(re, '<span class="glossary-term" data-term="$1">$1</span>');
    });
    if (replaced !== node.nodeValue) {
      const temp = document.createElement('span');
      temp.innerHTML = replaced;
      node.replaceWith(...temp.childNodes);
    }
  });
}

document.addEventListener("DOMContentLoaded", () => {
  wrapGlossaryTerms();

  const tooltip = document.createElement('div');
  tooltip.id = 'glossary-tooltip';
  document.body.appendChild(tooltip);

  document.addEventListener('mouseover', e => {
    const termEl = e.target.closest('.glossary-term');
    if (termEl) {
      tooltip.textContent = glossary[termEl.dataset.term] || '';
      tooltip.style.display = 'block';
    }
  });

  document.addEventListener('mousemove', e => {
    if (tooltip.style.display === 'block') {
      tooltip.style.left = (e.pageX + 10) + 'px';
      tooltip.style.top = (e.pageY + 10) + 'px';
    }
  });

  document.addEventListener('mouseout', e => {
    if (e.target.classList.contains('glossary-term')) {
      tooltip.style.display = 'none';
    }
  });
});